--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A creature object that has not been cloned. Typically represents the raw information edited in the construction set.
--- @class tes3creature : tes3actor, tes3physicalObject, tes3object, tes3baseObject
--- @field aiConfig tes3aiConfig *Read-only*. A substructure off of actors that contains information on the current AI configuration.
--- @field attacks tes3rangeInt[] A table of three attacks, represented by a trio of [`tes3rangeInt`](https://mwse.github.io/MWSE/types/tes3rangeInt/).
--- @field attributes number[] A table of eight numbers, representing the base values for the actor's attributes.
--- @field biped boolean Access to the creature's biped flag.
--- @field fatigue number *Read-only*. The actor's max fatigue.
--- @field flies boolean Access to the creature's flies flag.
--- @field health number *Read-only*. The actor's max health.
--- @field isAttacked boolean *Read-only*. If true, the actor's attacked flag is set.
--- @field isEssential boolean *Read-only*. If true, the actor's essential flag is set.
--- @field isInstance boolean Always returns false.
--- @field isRespawn boolean *Read-only*. If true, the actor's respawn flag is set.
--- @field level number *Read-only*. The base level of the creature.
--- @field magicka number *Read-only*. The actor's max magicka.
--- @field mesh string The path to the object's mesh.
--- @field name string The player-facing name for the object.
--- @field respawns boolean Access to the creature's respawns flag.
--- @field script tes3script The script that runs on the object.
--- @field skills number[] A table of three numbers, representing the base values for the creature's combat, magic, and stealth skills.
--- @field soul number The amount of soul value that the creature provides.
--- @field soundCreature tes3creature A creature to use instead of this one for sound generation.
--- @field spells tes3spellList|tes3spell[] *Read-only*. Quick access to the base creature's spell list. It is a `tes3spellList`, which is a list wrapper with helper functions. The actual list is iterated over using `pairs`. E.g. `for _, spell in pairs(creature.spells) do print(spell.name) end`. It is not recommended to directly modify this list; instead use tes3.addSpell and tes3.removeSpell.
--- @field swims boolean Access to the creature's swims flag.
--- @field type tes3.creatureType The type of the creature. Maps to [`tes3.creatureType`](https://mwse.github.io/MWSE/references/creature-types/) constants.
--- @field usesEquipment boolean Access to the creature's usesEquipment flag.
--- @field walks boolean Access to the creature's walks flag.
tes3creature = {}

--- Creates a copy of this object.
--- @param params tes3creature.createCopy.params This table accepts the following values:
--- 
--- `id?`: string — *Optional*. The new object's ID. If one is not provided, a randomly generated one will be used.
--- 
--- `addToObjectList?`: boolean — *Default*: `true`. If true, the object will be added to the data handler. If this is false, the new object may not have a randomly generated ID. Do not use this without knowing the implications.
--- 
--- `sourceless?`: boolean — *Default*: `false`. If true, the object will be made sourceless, and will not be serialized to the save game. If the object is copied outside of a save game, the object will **always** be sourceless.
--- @return tes3creature newObject No description yet available.
function tes3creature:createCopy(params) end

---Table parameter definitions for `tes3creature.createCopy`.
--- @class tes3creature.createCopy.params
--- @field id? string *Optional*. The new object's ID. If one is not provided, a randomly generated one will be used.
--- @field addToObjectList? boolean *Default*: `true`. If true, the object will be added to the data handler. If this is false, the new object may not have a randomly generated ID. Do not use this without knowing the implications.
--- @field sourceless? boolean *Default*: `false`. If true, the object will be made sourceless, and will not be serialized to the save game. If the object is copied outside of a save game, the object will **always** be sourceless.

